IF EXISTS(SELECT * FROM SYS.OBJECTS
			WHERE  
				OBJECT_ID = OBJECT_ID(N'[DBO].[P_ANALISE_PRODUTO_MEDIAF]') 
				AND TYPE IN(N'P', N'PC')
)
DROP PROCEDURE [DBO].[P_ANALISE_PRODUTO_MEDIAF];

GO

go
/*
=======================================================================================
'Job.................:  
'Função..............: 
'Objetivo............: Analise produto Media F
'Tabelas.............: 
'Dt Modificação......: 08/05/2021
'Modificação.........: Tag #A001 Data da ultima execução do grupo de curva
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 
*/
--EXEC P_ANALISE_PRODUTO_MEDIAF 1,350320,'1'
Create Procedure P_ANALISE_PRODUTO_MEDIAF(@cd_emp int , @cd_prod int, @listaFilial varchar(max) ='' ) 
AS
DECLARE @FLAG_NOVO_MODELO_PARAMETROS INT
SET @FLAG_NOVO_MODELO_PARAMETROS = ISNULL( ( SELECT VALOR FROM PRC_EMP_CONFIG
												WHERE  CD_EMP = 1   AND CD_CHAVE = 'FLAG_USA_NOVO_MODELO_PARAMETROS' ), 0);
SET NOCOUNT ON;
CREATE TABLE #tmpAnaliseMediaF(
			 CD_EMP int
			,CD_PROD int
			,CD_FILIAL	int
			,DS_SIGLA	varchar (2)
			,MEDIAF	money
			,QTDE_MEDIAF	money
			,QTDE_MEDIAP	money
			,ESEG	money
			,EMAX	money
			,DT_NASC	datetime
			,QTDE_MES_VENDA_FECHADO	int
			,QTDE_FACEAMENTO	money
			,VALID_QTDE_FACEAMENTO	datetime
			,QT_EST	money
			,QT_EST_EM_TERC	money
			,QT_EST_DE_TERC	money
			,QT_PEND_ENT	money
			,QT_PEND_SAI	money
			,DS_GRP_PARAM	varchar (250)
			,FREAV_MEDIAF_ULT_ATU	datetime
			,FREAV_MEDIAF	int
			,NM_GRUPO_RESSUP	varchar (100)
			,FRESSUP_ULT_ATU	datetime
			,FRESSUP	int
			,MEDIA_F_LIBERADA	int
			,DS_ARV_PARAM	varchar (250)
			,FCURVA_ULT_ATU	datetime
			,FCURVA	int
			,FLAG_OPERADOR_LOG	int
			,FILIAL_MTZ	int
			,QTDE_FINANCIADO	money
			,QTDE_LIMITADOR	money
			,STS_PROD_FILIAL	int
			,FLAG_VENDA_PERIODICA	int
			,FLAG_VENDA_CONSIGNADA	int
			,ESPECIE_FILIAL	int
			,STS_PROD		varchar(20)
			,DS_MOTIVO_STS	varchar (100)
			,FALTA_CRONICA	int
			,QT_VD_ATUAL	money
			,QT_VD_MES1	money
			,QT_VD_MES2	money
			,QT_VD_MES3	money
			,CD_ARV_MERC_LINHA int
			,CD_SIGLA int )


---------------------------------------------------------------------------------------------------
 
INSERT INTO #tmpAnaliseMediaF 
SELECT  
	 @cd_emp,@cd_prod,   e.CD_FILIAL AS CD_FILIAL
	 , ''  AS DS_SIGLA
	 , e.MEDIAF
	 , 0  AS QTDE_MEDIAF
	 , 0  AS QTDE_MEDIAP
	 , ISNULL(e.ESEG, 0) AS ESEG
	 , ISNULL(e.EMAX, 0) AS EMAX
	 , E.DT_NASC
	 , ISNULL(E.QTDE_MES_VENDA_FECHADO, 0) AS QTDE_MES_VENDA_FECHADO
	 , 0  QTDE_FACEAMENTO
	 , NULL  VALID_QTDE_FACEAMENTO
	 , ISNULL(E.QT_EST, 0) AS QT_EST
	 , ISNULL(E.QT_EST_EM_TERC, 0) AS QT_EST_EM_TERC
	 , ISNULL(E.QT_EST_DE_TERC, 0) AS QT_EST_DE_TERC
	 , ISNULL(E.QT_PEND_ENT, 0) AS QT_PEND_ENT
	 , ISNULL(E.QT_PEND_SAI, 0) AS QT_PEND_SAI
	 , '' AS DS_GRP_PARAM
	 , '' AS FREAV_MEDIAF_ULT_ATU
	 , '' AS FREAV_MEDIAF
	 , '' AS NM_GRUPO_RESSUP
	 , '' AS FRESSUP_ULT_ATU
	 , '' AS FRESSUP
	 , ISNULL(E.MEDIA_F_LIBERADA, 0) AS MEDIA_F_LIBERADA
	 , '' AS DS_ARV_PARAM
	 , '' AS FCURVA_ULT_ATU
	 , '' AS FCURVA
	 , PRC_FILIAL.FLAG_OPERADOR_LOG
	 , PRC_FILIAL.FILIAL_MTZ
	 , 0 QTDE_FINANCIADO
	 , 0 QTDE_LIMITADOR
	 , E.STS_PROD_FILIAL
	 , E.FLAG_VENDA_PERIODICA
	 , E.FLAG_VENDA_CONSIGNADA
	 , PRC_FILIAL.ESPECIE_FILIAL
	 , CASE
		   WHEN E.STS_PROD_FILIAL = 0 THEN 'ATIVO'
		   WHEN E.STS_PROD_FILIAL = 1 THEN 'INATIVO'
		   WHEN E.STS_PROD_FILIAL = 2 THEN 'BLOQUEADO'
		   ELSE 'BLOQUEADO'
	   END STS_PROD
	 , STS_FIL.DS_MOTIVO_STS
	 , 0  AS FALTA_CRONICA
	 , 0  AS QT_VD_ATUAL
	 , 0  AS QT_VD_MES1
	 , 0  AS QT_VD_MES2
	 , 0  AS QT_VD_MES3
	 ,l.CD_ARV_MERC_LINHA
	 ,e.CD_SIGLA
FROM
	V_EST_PROD_CPL_ESTOQUE E 
	INNER   JOIN EST_PROD_EST_ARV_MERCADOLOGICA L ON E.CD_EMP = L.CD_EMP
												   AND E.CD_PROD = L.CD_PROD
	INNER JOIN PRC_FILIAL ON E.CD_EMP = PRC_FILIAL.CD_EMP
					   AND E.CD_FILIAL = PRC_FILIAL.CD_FILIAL
	LEFT JOIN EST_PROD_MOTIVO_STS STS_FIL ON E.CD_EMP = STS_FIL.CD_EMP
											 AND E.CD_MOTIVO_STS_FILIAL = STS_FIL.CD_MOTIVO_STS
WHERE  E.CD_EMP = @cd_emp
	   AND E.CD_PROD =@cd_prod
	   AND PRC_FILIAL.STS_FILIAL = 0

---------------------------------------------------------------------------------------------------
if @listaFilial<> ''
begin
	
	delete from #tmpAnaliseMediaF
	where
		cd_filial 
			not in (select id from [dbo].[UFD_PRM_IN_STRING](@listaFilial))

end
 ---------------------------------------------------------------------------------------------------

	update e 
	Set
		QTDE_MEDIAP=p.QTDE_MEDIAP,
		FALTA_CRONICA=p.FALTA_CRONICA
	from
		#tmpAnaliseMediaF e
		JOIN EST_PROD_CPL_MEDIAP p ON		 E.CD_EMP	 = P.CD_EMP
											AND E.CD_FILIAL = P.CD_FILIAL
											AND E.CD_PROD	 = P.CD_PROD

	WHERE  p.CD_EMP = @cd_emp
		AND p.CD_PROD =@cd_prod; 
---------------------------------------------------------------------------------------------------

	update e 
	Set
		QTDE_MEDIAF			= f.QTDE_MEDIAF			 
		, QTDE_FINANCIADO	= f.QTDE_FINANCIADO
		, QTDE_LIMITADOR	= f.QTDE_LIMITADOR
		, QTDE_FACEAMENTO	= f.QTDE_FACEAMENTO
		, VALID_QTDE_FACEAMENTO = f.VALID_QTDE_FACEAMENTO
		, QT_VD_ATUAL= f.QT_VD_ATUAL
		, QT_VD_MES1 = f.QT_VD_MES1
		, QT_VD_MES2 = f.QT_VD_MES2
		, QT_VD_MES3 = f.QT_VD_MES3
	from
		#tmpAnaliseMediaF e
		JOIN EST_PROD_CPL_MEDIAF f ON		 E.CD_EMP	 = f.CD_EMP
		AND E.CD_FILIAL = f.CD_FILIAL
		AND E.CD_PROD	 = f.CD_PROD 
 WHERE  f.CD_EMP = @cd_emp
	   AND f.CD_PROD =@cd_prod;
	    
---------------------------------------------------------------------------------------------------
IF @FLAG_NOVO_MODELO_PARAMETROS=0 
BEGIN
update e 
	Set
	   DS_GRP_PARAM			= v.DS_GRP_PARAM
	 , FREAV_MEDIAF_ULT_ATU	= v.FREAV_MEDIAF_ULT_ATU
	 , FREAV_MEDIAF			= v.FREAV_MEDIAF
	from
		#tmpAnaliseMediaF e
		JOIN V_EST_PROD_EST_ARV_MERCADOLOGICA v ON		 E.CD_EMP	 = v.CD_EMP
													AND E.CD_FILIAL  = v.CD_FILIAL
													AND E.CD_PROD	 = v.CD_PROD

	WHERE   v.CD_EMP = @cd_emp
		AND v.CD_PROD =@cd_prod; 
END

-- Tag #A001 Data da ultima execução do grupo de curva
IF @FLAG_NOVO_MODELO_PARAMETROS=1
BEGIN
update e 
	Set
	   DS_GRP_PARAM			=  C.DS_GRP_PARAMETRO
	 , FREAV_MEDIAF_ULT_ATU	=  v.FRQ_MEDIAF_ULT_ATU
	 , FREAV_MEDIAF			=  cv.FREVISAOMEDIAF
	from
		#tmpAnaliseMediaF e
		JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD v ON		 E.CD_EMP	 = v.CD_EMP
													AND E.CD_FILIAL  = v.CD_FILIAL
													AND E.CD_PROD	 = v.CD_PROD
		JOIN EST_PARAM_COMPRAS_GRUPO C ON
		V.CD_ARV_PARAM = C.CD_CTR
		JOIN EST_PARAM_COMPRAS_GRUPO_CURVA_EST_PROD_CURVA_SIGLA Cv ON
		V.CD_GRUPO_CURVA = Cv.CD_GRUPO_CURVA AND
		V.CD_EMP = Cv.CD_EMP AND
		V.CD_SIGLA = Cv.CD_SIGLA
	WHERE   v.CD_EMP = @cd_emp
		AND v.CD_PROD =@cd_prod; 
END
 
---------------------------------------------------------------------------------------------------
	update e 
	Set
	    NM_GRUPO_RESSUP  = r.NM_GRUPO
	 ,  FRESSUP_ULT_ATU = r.FRESSUP_ULT_ATU
	 ,  FRESSUP=	r.FRESSUP
	from
	#tmpAnaliseMediaF e
	JOIN V_EST_ARV_GRP_RESSUPRIMENTO r ON E.CD_EMP = r.CD_EMP
											AND E.CD_FILIAL = r.CD_FILIAL
											AND e.CD_ARV_MERC_LINHA = r.CD_ARV_MERC_LINHA

---------------------------------------------------------------------------------------------------
IF @FLAG_NOVO_MODELO_PARAMETROS=0 
BEGIN
	update e
	set
	    DS_ARV_PARAM	= f.DS_ARV_PARAM
	 ,  FCURVA_ULT_ATU	= f.FCURVA_ULT_ATU
	 ,  FCURVA			= f.FCURVA
	from
		#tmpAnaliseMediaF e
		JOIN V_EST_ARV_MD_F_GRP_PARAM_CURVA_PRC_FILIAL f ON				 e.CD_EMP	 = f.CD_EMP
																	 AND e.CD_FILIAL = f.CD_FILIAL
																	 AND e.CD_PROD   = f.CD_PROD
																	 AND e.CD_SIGLA  = f.CD_SIGLA
	WHERE   f.CD_EMP = @cd_emp
		AND f.CD_PROD =@cd_prod;
END

IF @FLAG_NOVO_MODELO_PARAMETROS=1 
BEGIN
	update e
	set
	    DS_ARV_PARAM	= F.DS_ARV_PARAM
	 ,  FCURVA_ULT_ATU	= f.FCURVA_ULT_ATU
	 ,  FCURVA			= f.FCURVA
	from
		#tmpAnaliseMediaF e
		JOIN EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD f ON		 e.CD_EMP	 = f.CD_EMP
																	 AND e.CD_FILIAL = f.CD_FILIAL
																	 AND e.CD_PROD   = f.CD_PROD
																	 AND e.CD_SIGLA  = f.CD_SIGLA
	WHERE   f.CD_EMP = @cd_emp
		AND f.CD_PROD =@cd_prod;
END

---------------------------------------------------------------------------------------------------
	update 
	#tmpAnaliseMediaF
	set
		ds_sigla = case when cd_sigla= 5 then 'AA'
						when cd_sigla= 1 then 'A'
						when cd_sigla= 2 then 'B'
						when cd_sigla= 3 then 'C' 
						when cd_sigla= 4 then 'D'  END
---------------------------------------------------------------------------------------------------

select 
	 CD_FILIAL
	,DS_SIGLA
	,QTDE_MEDIAF
	,QTDE_MEDIAP
	,ESEG
	,EMAX
	,DT_NASC
	,QTDE_MES_VENDA_FECHADO
	,QTDE_FACEAMENTO
	,VALID_QTDE_FACEAMENTO
	,QT_EST
	,QT_EST_EM_TERC
	,QT_EST_DE_TERC
	,QT_PEND_ENT
	,QT_PEND_SAI
	,DS_GRP_PARAM
	,FREAV_MEDIAF_ULT_ATU
	,FREAV_MEDIAF
	,NM_GRUPO_RESSUP
	,FRESSUP_ULT_ATU
	,FRESSUP
	,MEDIA_F_LIBERADA
	,DS_ARV_PARAM
	,FCURVA_ULT_ATU
	,FCURVA
	,FLAG_OPERADOR_LOG
	,FILIAL_MTZ
	,QTDE_FINANCIADO
	,QTDE_LIMITADOR
	,STS_PROD_FILIAL
	,FLAG_VENDA_PERIODICA
	,FLAG_VENDA_CONSIGNADA
	,ESPECIE_FILIAL
	,STS_PROD
	,DS_MOTIVO_STS
	,FALTA_CRONICA
	,QT_VD_ATUAL
	,QT_VD_MES1
	,QT_VD_MES2
	,QT_VD_MES3
	,Convert(money, Round(((ESEG/30.000) * MEDIAF),0)) ESEG_QTDE
	,Convert(money, Round(((EMAX/30.000) * MEDIAF),0)) EMAX_QTDE 
from 
	#tmpAnaliseMediaF
